include <BOSL2/std.scad>

pill_dimensions = [21.6,7.64]; // (length;diameter) mm See https://www.lfacapsulefillers.com/capsule-size-chart
pill_capacity = [2,4];

thickness = 2; //mm (this needs to be at least 2x your nozzle size)
rounding = pill_dimensions.y/2; //mm

resolution = 100;
img_res = [502,360];

difference(){
x1 = [pill_dimensions.x*pill_capacity.x,pill_dimensions.y*pill_capacity.y,pill_dimensions.y/2+thickness*2];
cuboid(
    [pill_dimensions.x*pill_capacity.x+thickness*2,pill_dimensions.y*pill_capacity.y+thickness*2,pill_dimensions.y+thickness*3], rounding=rounding,
    edges=[RIGHT+FRONT,RIGHT+BACK,LEFT+FRONT,LEFT+BACK],
    anchor=BOT+LEFT+FRONT,
    $fn=resolution
);
translate([thickness,thickness,thickness+pill_dimensions.y/2])
cuboid(
    x1, rounding=rounding,
    edges=[RIGHT+FRONT,RIGHT+BACK,LEFT+FRONT,LEFT+BACK],
    anchor=BOT+LEFT+FRONT,
    $fn=resolution
);
for (i = [0:pill_capacity.x-1]) {
for (j = [0:pill_capacity.y-1]) { 
translate([pill_dimensions.x/2,pill_dimensions.y/2,pill_dimensions.y/2])
translate([pill_dimensions.x*i+thickness,pill_dimensions.y*j+thickness,thickness]) xcyl(d=pill_dimensions.y,h=pill_dimensions.x,rounding=rounding,anchor=CENTER,$fn=resolution);
}
}
translate([0,thickness/2,x1.z+pill_dimensions.y/2])
cuboid(
    [x1.x+thickness+thickness/2,x1.y+thickness,thickness/2], rounding=rounding,
    edges=[RIGHT+FRONT,RIGHT+BACK],
    anchor=BOT+LEFT+FRONT,
    $fn=resolution
);
}